function H=maskHC(H,MASK)
% H=function maskHC(H,MASK)
% Sets values in H to NaN for MASK==0
% H can be is cell array from readDat or readMT3D or readBud
% H can also be an array same size as MASK
%
% MASK is an array or scalar
% if mask is array (such as IBOUND) all zeros are reset to NaN
% if mask is a scalar, such as HNOFLOW or HDRY then all values > 0.999*MASK are set to NaN
% TO 090315 100420 100718

% Copyright 2009 Theo Olsthoorn, TU-Delft and Waternet, without any warranty
% under free software foundation GNU license version 3 or later

threshold=0.999;  % to prevent roundoff errors

if any(size(MASK)~=1)  % MASK is not a scalar
    if isnumeric(H)
        H(MASK==0)=NaN;
    else
        for i=1:length(H)
            H(i).values(MASK==0)=NaN;
        end
    end
else    % MASK is a scalar
    if isnumeric(H)
            H(H>threshold*MASK)=NaN;
    else
        for i=1:length(H)
            H(i).values(H(i).values>threshold*MASK)=NaN;
        end
    end
end